package com.ejie.ab04b.service;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.dao.VestadisticaFormaPreDao;
import com.ejie.ab04b.exception.AB04BException;
import com.ejie.ab04b.model.VestadisticaFormaPre;
import com.ejie.ab04b.util.PropertiesUtil;
import com.ejie.ab04b.util.Utilities;
import com.ejie.ab04b.webservice.client.documentowebservice.AlineacionCol;
import com.ejie.ab04b.webservice.client.documentowebservice.AlineacionZona;
import com.ejie.ab04b.webservice.client.documentowebservice.DefinicionCab;
import com.ejie.ab04b.webservice.client.documentowebservice.DefinicionCol;
import com.ejie.ab04b.webservice.client.documentowebservice.DefinicionPag;
import com.ejie.ab04b.webservice.client.documentowebservice.DefinicionPie;
import com.ejie.ab04b.webservice.client.documentowebservice.DocumentoWebServiceImpl;
import com.ejie.ab04b.webservice.client.documentowebservice.Elemento;
import com.ejie.ab04b.webservice.client.documentowebservice.Grupo;
import com.ejie.ab04b.webservice.client.documentowebservice.Modo;
import com.ejie.ab04b.webservice.client.documentowebservice.Orientacion;
import com.ejie.ab04b.webservice.client.documentowebservice.Tamano;
import com.ejie.ab04b.webservice.client.documentowebservice.Tipo;
import com.ejie.ab04b.webservice.client.documentowebservice.Zona;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * VestadisticaFormaPreServiceImpl generated by UDA, 18-sep-2017 9:23:56.
 * 
 * @author UDA
 */

@Service(value = "vestadisticaFormaPreService")
public class VestadisticaFormaPreServiceImpl
		implements VestadisticaFormaPreService {

	@Autowired()
	private DocumentoWebServiceImpl documentoWebServiceImpl;

	@Autowired()
	private Properties appConfiguration;

	@Autowired()
	private ReloadableResourceBundleMessageSource appMessageSource;

	@Autowired()
	private VestadisticaFormaPreDao vestadisticaFormaPreDao;

	private static final Logger logger = LoggerFactory
			.getLogger(VestadisticaFormaPreServiceImpl.class);

	/**
	 * Inserts a single row in the VestadisticaFormaPre table.
	 * 
	 * vestadisticaFormaPre VestadisticaFormaPre VestadisticaFormaPre
	 *
	 * @param vestadisticaFormaPre
	 *            the vestadistica forma pre
	 * @return the vestadistica forma pre
	 */
	@Transactional(rollbackFor = Throwable.class)
	public VestadisticaFormaPre add(VestadisticaFormaPre vestadisticaFormaPre) {
		return this.vestadisticaFormaPreDao.add(vestadisticaFormaPre);
	}

	/**
	 * Updates a single row in the VestadisticaFormaPre table.
	 * 
	 * vestadisticaFormaPre VestadisticaFormaPre VestadisticaFormaPre
	 *
	 * @param vestadisticaFormaPre
	 *            the vestadistica forma pre
	 * @return the vestadistica forma pre
	 */
	@Transactional(rollbackFor = Throwable.class)
	public VestadisticaFormaPre update(
			VestadisticaFormaPre vestadisticaFormaPre) {
		return this.vestadisticaFormaPreDao.update(vestadisticaFormaPre);
	}

	/**
	 * Finds a single row in the VestadisticaFormaPre table.
	 * 
	 * vestadisticaFormaPre VestadisticaFormaPre VestadisticaFormaPre
	 *
	 * @param vestadisticaFormaPre
	 *            the vestadistica forma pre
	 * @return the vestadistica forma pre
	 */
	public VestadisticaFormaPre find(
			VestadisticaFormaPre vestadisticaFormaPre) {
		return (VestadisticaFormaPre) this.vestadisticaFormaPreDao
				.find(vestadisticaFormaPre);
	}

	/**
	 * Deletes a single row in the VestadisticaFormaPre table.
	 * 
	 * vestadisticaFormaPre VestadisticaFormaPre
	 *
	 * @param vestadisticaFormaPre
	 *            the vestadistica forma pre
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(VestadisticaFormaPre vestadisticaFormaPre) {
		this.vestadisticaFormaPreDao.remove(vestadisticaFormaPre);
	}

	/**
	 * Finds a list of rows in the VestadisticaFormaPre table.
	 * 
	 * vestadisticaFormaPre VestadisticaFormaPre jqGridRequestDto
	 * JQGridRequestDto List<VestadisticaFormaPre>
	 *
	 * @param vestadisticaFormaPre
	 *            the vestadistica forma pre
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	public List<VestadisticaFormaPre> findAll(
			VestadisticaFormaPre vestadisticaFormaPre,
			JQGridRequestDto jqGridRequestDto) {
		return (List<VestadisticaFormaPre>) this.vestadisticaFormaPreDao
				.findAll(vestadisticaFormaPre, jqGridRequestDto);
	}

	/**
	 * Finds rows in the VestadisticaFormaPre table using like.
	 * 
	 * vestadisticaFormaPre VestadisticaFormaPre jqGridRequestDto
	 * JQGridRequestDto startsWith Boolean List<VestadisticaFormaPre>
	 *
	 * @param vestadisticaFormaPre
	 *            the vestadistica forma pre
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	public List<VestadisticaFormaPre> findAllLike(
			VestadisticaFormaPre vestadisticaFormaPre,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<VestadisticaFormaPre>) this.vestadisticaFormaPreDao
				.findAllLike(vestadisticaFormaPre, jqGridRequestDto,
						startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the VestadisticaFormaPre table.
	 * 
	 * filterVestadisticaFormaPre VestadisticaFormaPre jqGridRequestDto
	 * JQGridRequestDto startsWith Boolean
	 *
	 * @param filterVestadisticaFormaPre
	 *            the filter vestadistica forma pre
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 */
	public void removeMultiple(VestadisticaFormaPre filterVestadisticaFormaPre,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.vestadisticaFormaPreDao.removeMultiple(filterVestadisticaFormaPre,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Filter method in the VestadisticaFormaPre table.
	 * 
	 * filterVestadisticaFormaPre VestadisticaFormaPre jqGridRequestDto
	 * JQGridRequestDto startsWith Boolean JQGridResponseDto
	 * <VestadisticaFormaPre>
	 *
	 * @param filterVestadisticaFormaPre
	 *            the filter vestadistica forma pre
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<VestadisticaFormaPre> filter(
			VestadisticaFormaPre filterVestadisticaFormaPre,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<VestadisticaFormaPre> listaVestadisticaFormaPre = this.vestadisticaFormaPreDao
				.findAllLike(filterVestadisticaFormaPre, jqGridRequestDto,
						false);
		Long recordNum = this.vestadisticaFormaPreDao.findAllLikeCount(
				filterVestadisticaFormaPre != null ? filterVestadisticaFormaPre
						: new VestadisticaFormaPre(),
				false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<VestadisticaFormaPre>> reorderSelection = this.vestadisticaFormaPreDao
					.reorderSelection(filterVestadisticaFormaPre,
							jqGridRequestDto, startsWith);
			return new JQGridResponseDto<VestadisticaFormaPre>(jqGridRequestDto,
					recordNum, listaVestadisticaFormaPre, reorderSelection);
		}
		return new JQGridResponseDto<VestadisticaFormaPre>(jqGridRequestDto,
				recordNum, listaVestadisticaFormaPre);
	}

	/**
	 * Searches rows in the VestadisticaFormaPre table.
	 * 
	 * filterVestadisticaFormaPre VestadisticaFormaPre
	 * searchVestadisticaFormaPre VestadisticaFormaPre jqGridRequestDto
	 * JQGridRequestDto startsWith Boolean List<TableRowDto
	 * <VestadisticaFormaPre>>
	 *
	 * @param filterVestadisticaFormaPre
	 *            the filter vestadistica forma pre
	 * @param searchVestadisticaFormaPre
	 *            the search vestadistica forma pre
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	public List<TableRowDto<VestadisticaFormaPre>> search(
			VestadisticaFormaPre filterVestadisticaFormaPre,
			VestadisticaFormaPre searchVestadisticaFormaPre,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.vestadisticaFormaPreDao.search(filterVestadisticaFormaPre,
				searchVestadisticaFormaPre, jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in VestadisticaFormaPre table.
	 * 
	 * filterVestadisticaFormaPre VestadisticaFormaPre jqGridRequestDto
	 * JQGridRequestDto startsWith Boolean Object
	 *
	 * @param filterVestadisticaFormaPre
	 *            the filter vestadistica forma pre
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the object
	 */
	public Object reorderSelection(
			VestadisticaFormaPre filterVestadisticaFormaPre,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.vestadisticaFormaPreDao.reorderSelection(
				filterVestadisticaFormaPre, jqGridRequestDto, startsWith);
	}

	/**
	 * Devuelve la ruta del pdf creado.
	 * 
	 * filtro VestadisticaFormaPre jqGridRequestDto JQGridRequestDto String
	 *
	 * @param filtro
	 *            the filtro
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the string
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	public String filterVestadisticaFormaPrePDF(VestadisticaFormaPre filtro,
			JQGridRequestDto jqGridRequestDto) throws AB04BException {
		try {
			String informe = "";

			HashMap<String, String> hmDatosFila = new HashMap<String, String>();
			List<HashMap<String, String>> hmDatos = new ArrayList<HashMap<String, String>>();

			List<VestadisticaFormaPre> listadoEstadistica = this.vestadisticaFormaPreDao
					.findAllLike(filtro, jqGridRequestDto, false);

			if (!listadoEstadistica.isEmpty()) {

				for (int i = 0; i < listadoEstadistica.size(); i++) {

					hmDatosFila = this.inicializarHmDatosFila();

					hmDatosFila.put("territorio",
							listadoEstadistica.get(i).getTerDesc());
					hmDatosFila.put("anio",
							listadoEstadistica.get(i).getAnio());
					hmDatosFila.put("mes", listadoEstadistica.get(i).getMes());
					hmDatosFila.put("semana",
							listadoEstadistica.get(i).getSemana());
					hmDatosFila.put("procedimiento",
							listadoEstadistica.get(i).getProcedimientoDesc());
					hmDatosFila.put("telematico", listadoEstadistica.get(i)
							.getTelematico().toString());
					hmDatosFila.put("presencial", listadoEstadistica.get(i)
							.getPresencial().toString());
					hmDatosFila.put("total",
							listadoEstadistica.get(i).getTotal().toString());

					hmDatos.add(hmDatosFila);
				}
			}

			DefinicionCab defCab;
			String titulo = "";
			DefinicionPie defPie = null;

			defCab = this.setDefinicionCab(filtro.getTerritorio());
			Locale locale = LocaleContextHolder.getLocale();

			defPie = this.setDefinicionPie();

			titulo = this.appMessageSource
					.getMessage("titulo.listadoFormaPre", null, locale)
					.toUpperCase();

			String descProvincia;

			if (filtro.getTerritorio() != null) {
				descProvincia = Utilities.getInstance()
						.strTerritorio(filtro.getTerritorio());
			} else {
				descProvincia = this.appMessageSource.getMessage("label.todos",
						null, locale);
			}
			filtro.setTerDesc(descProvincia);

			String tituloConFiltro = this.obtenerTituloFiltro(titulo, filtro,
					null);

			DefinicionPag defPag = this.setDefinicionPag(tituloConFiltro);

			String modo;
			modo = Modo.PDF.toString();

			// Grupos
			List<Grupo> listaGrupos = new ArrayList<Grupo>();
			listaGrupos.add(
					new Grupo(this.obtenerVestadisticaFormaPrePDF(), "GRUPO1"));

			String jsonString = this.convertirJson(hmDatos);
			String jsonStringGr = this.convertirJsonGr(listaGrupos);

			String extension = ".pdf";

			String rutaPif = this.appConfiguration
					.getProperty(PropertiesUtil.PIF_RUTA_APP)
					.concat(titulo.replace("(", "-").replace(")", "-"))
					.concat(extension);
			informe = this.documentoWebServiceImpl.generarInformePif(
					jsonStringGr, defPag, jsonString, defCab, defPie, modo,
					rutaPif);

			return informe;
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * MÃ©todo para crear la definiciÃ³n de la cabecera (Zona zona1, Zona zona2,
	 * Zona zona3, Integer tam), las zonas (String tipo, Elemento elemento,
	 * String alineacion) y los elementos (String text, byte[] img).
	 * 
	 * territorio String DefinicionCab
	 *
	 * @param territorio
	 *            the territorio
	 * @return the definicion cab
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	private DefinicionCab setDefinicionCab(String territorio)
			throws AB04BException {
		// try {
		Locale locale = LocaleContextHolder.getLocale();

		// String codDelegacion = K72BXLNetUtils.dameDelegacion();
		// String file =
		// this.appConfiguration.getProperty("ruta.imagen".concat(codDelegacion));
		String file = "";
		if (territorio != null) {
			file = this.appConfiguration
					.getProperty("ruta.imagen".concat(territorio));
		} else {
			file = this.appConfiguration
					.getProperty("ruta.imagen".concat(Constantes.TH_TODOS));
		}

		ByteArrayOutputStream ous = null;
		// InputStream ios = null;
		FileInputStream ios = null;
		try {
			byte[] buffer = new byte[Constantes.STRING_BUILDER_INIT];
			ous = new ByteArrayOutputStream();

			ios = new FileInputStream(file);

			int read = 0;
			try {
				while ((read = ios.read(buffer)) != -1) {

					ous.write(buffer, 0, read);
				}
			} catch (IOException e) {
				throw new AB04BException(e, e.getMessage());
			} finally {
				try {
					if (ios != null) {
						ios.close();
					}
				} catch (IOException e) {
					VestadisticaFormaPreServiceImpl.logger
							.error("ERROR en setDefinicionCab", e);
				}
			}

			byte[] img = ous.toByteArray();

			Date now = new Date();

			String s1 = Utilities.getInstance().formatearDateIdioma(now);

			// DefinicionCab
			return new DefinicionCab(
					new Zona(Tipo.TEXTO,
							new Elemento(
									this.appMessageSource
											.getMessage("titulo.aplicacion",
													null, locale)
											.toUpperCase(),
									null),
							AlineacionZona.CENTRO),
					new Zona(Tipo.IMAGEN, new Elemento(null, img),
							AlineacionZona.CENTRO),
					new Zona(
							Tipo.TEXTO, new Elemento(
									this.appMessageSource
											.getMessage("titulo.fecha", null,
													locale)
											.toUpperCase().concat(" ")
											.concat(s1),
									null),
							AlineacionZona.CENTRO),
					Constantes.CIENTO_TREINTA);
		} catch (IOException e) {
			throw new AB04BException(e, e.getMessage());
		} finally {
			try {
				if (ous != null) {
					ous.close();
				}

				if (ios != null) {
					ios.close();
				}
			} catch (IOException e) {
				VestadisticaFormaPreServiceImpl.logger
						.error("ERROR en setDefinicionCab", e);
			}
		}
		// } catch (Exception e) {
		// throw new AB04BException(e, e.getMessage());
		// }
	}

	/**
	 * Obtener vestadistica forma pre PDF.
	 * 
	 * List<DefinicionCol>
	 *
	 * @return the list
	 */
	private List<DefinicionCol> obtenerVestadisticaFormaPrePDF() {

		Locale locale = LocaleContextHolder.getLocale();
		List<DefinicionCol> listaColumnas = new ArrayList<DefinicionCol>();
		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.territorio", null,
						locale),
				"territorio", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.anyo", null, locale),
				"anio", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.mes", null, locale),
				"mes", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.semana", null, locale),
				"semana", Constantes.TRES, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.procedimiento", null,
						locale),
				"procedimiento", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.telematico", null,
						locale),
				"telematico", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.presencial", null,
						locale),
				"presencial", Constantes.TRES, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		listaColumnas.add(new DefinicionCol(
				this.appMessageSource.getMessage("titulo.total", null, locale),
				"total", Constantes.DOS, AlineacionCol.IZQUIERDA,
				Constantes.NUEVE, Constantes.DOS, false, true));

		return listaColumnas;
	}

	/**
	 * Obtener titulo filtro.
	 * 
	 * titulo String filtro ComunicacionApertura fechaObtencion Date String
	 *
	 * @param titulo
	 *            the titulo
	 * @param filtro
	 *            the filtro
	 * @param fechaObtencion
	 *            the fecha obtencion
	 * @return the string
	 */
	private String obtenerTituloFiltro(String titulo,
			VestadisticaFormaPre filtro, Date fechaObtencion) {

		Locale locale = LocaleContextHolder.getLocale();
		StringBuilder tituloConFiltro = new StringBuilder(
				Constantes.TAMANYO_3000);
		String tab = "   ";

		tituloConFiltro.append(titulo);
		tituloConFiltro.append("\n");
		if (filtro.getTerDesc() != null) {
			tituloConFiltro.append(tab);
			tituloConFiltro.append(this.appMessageSource
					.getMessage("titulo.territorio", null, locale));
			tituloConFiltro.append(":" + tab);
			tituloConFiltro.append(filtro.getTerDesc());
		}
		if (filtro.getAnio() != null) {
			tituloConFiltro.append(tab);
			tituloConFiltro.append(this.appMessageSource
					.getMessage("titulo.obra", null, locale));
			tituloConFiltro.append(":" + tab);
			tituloConFiltro.append(filtro.getAnio());
		}
		if (filtro.getMes() != null) {
			tituloConFiltro.append(tab);
			tituloConFiltro.append(this.appMessageSource
					.getMessage("titulo.anyo", null, locale));
			tituloConFiltro.append(":" + tab);
			tituloConFiltro.append(filtro.getMes());
		}
		if (filtro.getSemana() != null) {
			tituloConFiltro.append(tab);
			tituloConFiltro.append(this.appMessageSource
					.getMessage("titulo.numexpDesde", null, locale));
			tituloConFiltro.append(":" + tab);
			tituloConFiltro.append(filtro.getSemana());
		}
		if (filtro.getProcedimientoDesc() != null) {
			tituloConFiltro.append(tab);
			tituloConFiltro.append(this.appMessageSource
					.getMessage("titulo.numexpHasta", null, locale));
			tituloConFiltro.append(":" + tab);
			tituloConFiltro.append(filtro.getProcedimientoDesc());
		}
		if (filtro.getTelematico() != null) {
			tituloConFiltro.append(tab);
			tituloConFiltro.append(this.appMessageSource
					.getMessage("titulo.fecpreDesde", null, locale));
			tituloConFiltro.append(":" + tab);
			tituloConFiltro.append(filtro.getTelematico());
		}
		if (filtro.getPresencial() != null) {
			tituloConFiltro.append(tab);
			tituloConFiltro.append(this.appMessageSource
					.getMessage("titulo.fecpreHasta", null, locale));
			tituloConFiltro.append(":" + tab);
			tituloConFiltro.append(filtro.getPresencial());
		}
		if (filtro.getTotal() != null) {
			tituloConFiltro.append(tab);
			tituloConFiltro.append(this.appMessageSource
					.getMessage("titulo.fecObtencion", null, locale));
			tituloConFiltro.append(":" + tab);
			tituloConFiltro.append(filtro.getTotal());
		}

		return tituloConFiltro.toString();
	}

	/**
	 * MÃ©todo para convertir la lista de Datos antes creada a un String y
	 * pasarlo como JSON a el web service.
	 * 
	 * listaInforme List<HashMap<String, String>> String
	 *
	 * @param listaInforme
	 *            the lista informe
	 * @return the string
	 * @throws JsonGenerationException
	 *             JsonGenerationException
	 * @throws JsonMappingException
	 *             JsonMappingException
	 * @throws IOException
	 *             IOException
	 */
	private String convertirJson(List<HashMap<String, String>> listaInforme)
			throws JsonGenerationException, JsonMappingException, IOException {

		String json = null;
		ObjectMapper objMapper = new ObjectMapper();
		json = objMapper.writeValueAsString(listaInforme);

		return json;
	}

	/**
	 * MÃ©todo para convertir la lista de Grupos antes creada a un String y
	 * pasarlo como JSON a el web service.
	 * 
	 * listaGrupos List<Grupo> String
	 *
	 * @param listaGrupos
	 *            the lista grupos
	 * @return the string
	 * @throws JsonGenerationException
	 *             JsonGenerationException
	 * @throws JsonMappingException
	 *             JsonMappingException
	 * @throws IOException
	 *             IOException
	 */
	private String convertirJsonGr(List<Grupo> listaGrupos)
			throws JsonGenerationException, JsonMappingException, IOException {

		String json = null;
		ObjectMapper objMapper = new ObjectMapper();
		json = objMapper.writeValueAsString(listaGrupos);

		return json;
	}

	/**
	 * Inicializar hm datos fila.
	 * 
	 * HashMap
	 *
	 * @return the hash map
	 */
	public HashMap<String, String> inicializarHmDatosFila() {
		return new HashMap<String, String>();
	}

	/**
	 * MÃ©todo para crear la definiciÃ³n del pie de pÃ¡gina (String text1,
	 * String text2, String text3, Integer tam).
	 * 
	 * DefinicionPie
	 *
	 * @return the definicion pie
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	private DefinicionPie setDefinicionPie() throws AB04BException {
		try {

			// String tituloDes =
			// this.k72CrearXMLInformeService.devolverPiePagina();
			String tituloDes = "";
			return new DefinicionPie("", tituloDes, "numpag", Constantes.CIEN);
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * MÃ©todo para crear la definiciÃ³n de la pÃ¡gina (String orientacion,
	 * Integer tamanoLetra, String tamanoPag, String textoAdicional).
	 * 
	 * titulo String DefinicionPag
	 *
	 * @param titulo
	 *            the titulo
	 * @return the definicion pag
	 */
	private DefinicionPag setDefinicionPag(String titulo) {
		return new DefinicionPag(Orientacion.HORIZONTAL,

				Constantes.DIEZ, Tamano.A4, titulo);
	}

}
